///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK EditScheduleDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
	static HWND BackupWindowTimeBegin_hWnd;
	static HWND BackupWindowTimeEnd_hWnd;
	static HWND StartOnceTime_hWnd;

	static HWND IncrementMinuteUD_hWnd;
	static HWND IncrementMinute_hWnd;

	static HWND IncrementHourUD_hWnd;
	static HWND IncrementHour_hWnd;

	if(xMessage == WM_INITDIALOG) // Received A Initilize Dialog Message
	{
		EditScheduleDialog_hWnd = xHandle;

		SendMessage(EditScheduleDialog_hWnd,(UINT)WM_SETTEXT,(WPARAM)0,(LPARAM)"Edit Schedule");
		SendMessage(EditScheduleDialog_hWnd,WM_SETICON,TRUE,(LPARAM)LoadIcon(MainInstance,MAKEINTRESOURCE(DialogIcon)));

		BackupWindowTimeBegin_hWnd	   = GetDlgItem(EditScheduleDialog_hWnd, 4000);
		BackupWindowTimeEnd_hWnd	   = GetDlgItem(EditScheduleDialog_hWnd, 4001);

        StartOnceTime_hWnd = GetDlgItem(EditScheduleDialog_hWnd, 5000);

		IncrementHour_hWnd	   = GetDlgItem(EditScheduleDialog_hWnd, 2000);
		IncrementHourUD_hWnd   = GetDlgItem(EditScheduleDialog_hWnd, 2001);

		IncrementMinute_hWnd   = GetDlgItem(EditScheduleDialog_hWnd, 3000);
    	IncrementMinuteUD_hWnd = GetDlgItem(EditScheduleDialog_hWnd, 3001);

		SendMessage(IncrementHourUD_hWnd,(UINT)UDM_SETBUDDY, (WPARAM)IncrementHour_hWnd, (LPARAM)NULL);
		SendMessage(IncrementHourUD_hWnd,(UINT)UDM_SETRANGE, (WPARAM)NULL,(LPARAM)MAKELONG(23, 0));

		SendMessage(IncrementMinuteUD_hWnd,(UINT)UDM_SETBUDDY, (WPARAM)IncrementMinute_hWnd, (LPARAM)NULL);
		SendMessage(IncrementMinuteUD_hWnd,(UINT)UDM_SETRANGE, (WPARAM)NULL, (LPARAM)MAKELONG(59, 0));

		SetDlgItemInt(EditScheduleDialog_hWnd, 2000, Sched[ESD.EditItem].IncrementHour,   FALSE);
		SetDlgItemInt(EditScheduleDialog_hWnd, 3000, Sched[ESD.EditItem].IncrementMinute, FALSE);

        SYSTEMTIME ST;

        GetLocalTime(&ST);

		int Hour, Minute, Second;
		LongToTime(Sched[ESD.EditItem].BackupWindowTimeBegin, &Hour, &Minute, &Second);
		ST.wHour   = Hour;
		ST.wMinute = Minute;
		ST.wSecond = Second;
		SendMessage(BackupWindowTimeBegin_hWnd, MCM_SETCURSEL, (WPARAM) 0, (LPARAM) (LPSYSTEMTIME) &ST);

		LongToTime(Sched[ESD.EditItem].BackupWindowTimeEnd, &Hour, &Minute, &Second);
		ST.wHour   = Hour;
		ST.wMinute = Minute;
		ST.wSecond = Second;
		SendMessage(BackupWindowTimeEnd_hWnd, MCM_SETCURSEL, (WPARAM) 0, (LPARAM) (LPSYSTEMTIME) &ST);

		LongToTime(Sched[ESD.EditItem].StartOnceTime, &Hour, &Minute, &Second);
		ST.wHour   = Hour;
		ST.wMinute = Minute;
		ST.wSecond = Second;
		SendMessage(StartOnceTime_hWnd, MCM_SETCURSEL, (WPARAM) 0, (LPARAM) (LPSYSTEMTIME) &ST);

        if( Sched[ESD.EditItem].OnlyRunOnce )
        {
            CheckDlgButton(EditScheduleDialog_hWnd, 7000, BST_CHECKED);
            SchedChangeAllOnMultipleRadio(EditScheduleDialog_hWnd, TRUE);
            SchedChangeAllOnSingleRadio(EditScheduleDialog_hWnd, FALSE);
        }
        else{
            CheckDlgButton(EditScheduleDialog_hWnd, 6000, BST_CHECKED);
            SchedChangeAllOnMultipleRadio(EditScheduleDialog_hWnd, FALSE);
            SchedChangeAllOnSingleRadio(EditScheduleDialog_hWnd, TRUE);
        }

        BOD.Complete   = FALSE;
        SQLOD.Complete = FALSE;

        EnableWindow( GetDlgItem(EditScheduleDialog_hWnd, 101), FALSE);

 		CenterWindow(EditScheduleDialog_hWnd);

        LoadWeekDaysFromScheduleItemIntoDialog(EditScheduleDialog_hWnd, ESD.EditItem);

		return 0;
	}


	if(xMessage == WM_COMMAND) // Received A Message
	{
        BOOL OncePerDay = FALSE;

        if( IsDlgButtonChecked(EditScheduleDialog_hWnd, 7000) == TRUE)
            OncePerDay = TRUE;
        else OncePerDay = FALSE;

		if(wParam == 6000) //- Run multiple times per day check box (Dialog Command)
		{
            SchedChangeAllOnMultipleRadio(EditScheduleDialog_hWnd, FALSE);
            SchedChangeAllOnSingleRadio(EditScheduleDialog_hWnd, TRUE);
            return 0;
		}

		if(wParam == 7000) //- Run once per day check box (Dialog Command)
		{
            SchedChangeAllOnMultipleRadio(EditScheduleDialog_hWnd, TRUE);
            SchedChangeAllOnSingleRadio(EditScheduleDialog_hWnd, FALSE);
            return 0;
        }

		if(wParam == 100) //- Ok (Dialog Command)
		{
            if( IsAtleastOneDayChecked(EditScheduleDialog_hWnd) == FALSE)
            {
                MessageBox(EditScheduleDialog_hWnd, "You must select at least one day.", TitleCaption, MB_TASKMODAL);
                return 0;
            }

            int IncrementMinute = CharInt( Get_Text(IncrementMinute_hWnd) );
            int IncrementHour   = CharInt( Get_Text(IncrementHour_hWnd) );

            if(IncrementMinute == 0 && IncrementHour == 0 && OncePerDay == FALSE)
            {
                MessageBox(EditScheduleDialog_hWnd, "The scheduled backup must increment by some value. Hour or minute.", TitleCaption, MB_TASKMODAL);
                return 0;
            }

            if(SQLOD.Complete == TRUE)
            {
                Sched[ESD.EditItem].SQLServer        = SQLOD.SQLServer;
                Sched[ESD.EditItem].Database         = SQLOD.DataBase;
                Sched[ESD.EditItem].DBDriver         = SQLOD.DBDriver;
                Sched[ESD.EditItem].Username         = SQLOD.UserName;
                Sched[ESD.EditItem].Password         = SQLOD.Password;
            }

            if(BOD.Complete == TRUE)
            {
                Sched[ESD.EditItem].Name             = BOD.BackupName;
                Sched[ESD.EditItem].Description      = BOD.BackupDescription;
                Sched[ESD.EditItem].Filename         = BOD.BackupFileName;
            }

			SYSTEMTIME Time;
			GetSystemTime(&Time);

            SendMessage(BackupWindowTimeBegin_hWnd, MCM_GETCURSEL, (WPARAM) 0, (LPARAM) (LPSYSTEMTIME) &Time);
            Sched[ESD.EditItem].BackupWindowTimeBegin = TimeToLong(Time.wHour, Time.wMinute, Time.wSecond);

            SendMessage(BackupWindowTimeEnd_hWnd, MCM_GETCURSEL, (WPARAM) 0, (LPARAM) (LPSYSTEMTIME) &Time);
            Sched[ESD.EditItem].BackupWindowTimeEnd = TimeToLong(Time.wHour, Time.wMinute, Time.wSecond);

            SendMessage(StartOnceTime_hWnd, MCM_GETCURSEL, (WPARAM) 0, (LPARAM) (LPSYSTEMTIME) &Time);
            Sched[ESD.EditItem].StartOnceTime = TimeToLong(Time.wHour, Time.wMinute, Time.wSecond);

            Sched[ESD.EditItem].OnlyRunOnce      = OncePerDay;
            Sched[ESD.EditItem].OnHold           = FALSE;
            Sched[ESD.EditItem].Active           = TRUE;
            Sched[ESD.EditItem].ScheduleSet      = TRUE;

            Sched[ESD.EditItem].IncrementHour    = IncrementHour;
            Sched[ESD.EditItem].IncrementMinute  = IncrementMinute;

            LoadWeekDaysFromDialogIntoScheduleItem(EditScheduleDialog_hWnd, ESD.EditItem);

            CalculateSchedules();
            ListView_DeleteAllItems(SD.ListView_hWnd);
            LoadScheduleIntoDialog();

			EndDialog(EditScheduleDialog_hWnd,0);

			return 0;
		}

		if(wParam==102) //- Backup Options (Dialog Command)
		{
        	DialogBox(MainInstance, MAKEINTRESOURCE(AddBackupOptions), EditScheduleDialog_hWnd, EditBackupOptionsDialog);
			return 0;
		}

		if(wParam==103) //- SQL Options (Dialog Command)
		{
        	DialogBox(MainInstance, MAKEINTRESOURCE(AddSQLOptions), EditScheduleDialog_hWnd, EditSQLOptionsDialog);
			return 0;
		}

        if(wParam == 105) //- All Checked (Dialog Command)
        {
            CheckAllWeekDays(EditScheduleDialog_hWnd);
            return 0;
        }

        if(wParam == 106) //- None Checked (Dialog Command)
        {
            UnCheckAllWeekDays(EditScheduleDialog_hWnd);
            return 0;
        }

		return 0;
	}

	return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

